program spielen;
uses graph, crt, dos;
{Typendeklaration}
  type eintragtyp = record
                      Artikel: string[3];
                      wortdt: string[30];
                      wortpl: string[30];
                      wortengl: string[30];
                      satznr: longint;
                    end;
  type substfiletyp = File of eintragtyp;
  type schreibtyp = string[80];
  type worttyp = string[30];
  type msktyp = string[15];

{Konstantendeklaration}
  const sname = '*.dat';
        erwei = '.dat';

{Variablendeklaration}
  var Palette: PaletteType;
  var eintrag: eintragtyp;
      verglei: eintragtyp;
      substfile: substfiletyp;
      satzanzahl: longint;
      zeichen: char;
      sp: byte;
      csp: byte;
      beenden:char;
  var name: string[8];
      oname: string[33];
      suchpfad: string[79];
      datei: SearchRec;
      spfad: string[67];
      x,y: byte;
      fehler: byte;

procedure grafstart;
  var GraphDriver, GraphMode : integer;
  begin
    SetGraphBufSize(3000);
    GraphDriver:=9;
    GraphMode:=1;
    InitGraph(Graphdriver, Graphmode, 'a:\bgi');
    SetAllPalette(Palette);
    SetWriteMode(0);
  end;
procedure fensteraufbau(a,b,c,d: integer; e,f: word);
  begin
    SetFillStyle(e,f);
    Bar(a,b,c,d);
  end;

procedure spieler(column,linie: integer; farb: word; rich: char);
  begin
    SetColor(0);
    SetLineStyle(0,0,3);
    line(column+15,linie+17,column+15,linie+33);  {Krper}
    ellipse(column+15,linie+8,0,180,8,6);     {Gesicht}
    line(column+7,linie+8,column+23,linie+8);
    ellipse(column+15,linie+8,180,0,8,6);     {Mtze}
    SetColor(farb);
    line(column+10,linie+5,column+20,linie+5);
    SetColor(0);
    if rich='r'
      then begin
        line(column+6,linie+17,column+24,linie+30);   {Arme}
        line(column+15,linie+33,column+6,linie+46);  {Beine}
        line(column+15,linie+33,column+28,linie+55);
      end
      else begin
        line(column+24,linie+17,column+6,linie+30);   {Arme}
        line(column+15,linie+33,column+24,linie+46);  {Beine}
        line(column+15,linie+33,column+6,linie+55);
      end;
  end;

procedure ballzeichn(c,d:integer);
      begin
        SetColor(15);
        SetLineStyle(0,0,3);
        SetFillStyle(7,15);
        FillEllipse(c,d,10,9);
      end;

procedure zaehler;
  var stasp: string[2];
      stacsp: string[2];
  begin
    if sp in [0..9] then stasp:=char(32)+char(sp+48);
    if sp in [10..19] then stasp:=char(49)+char(sp+38);
    if csp in [0..9] then stacsp:=char(32)+char(csp+48);
    if csp in [10..19] then stacsp:=char(49)+char(csp+38);
    SetColor(0);
    SetTextStyle(0,0,1);
    fensteraufbau(501,0,640,250,1,15);   {Zhlerfeld}
    OutTextXY(502,5,'Score:');
    OutTextXY(502,69,'Player  :'); OutTextXY(590,69,stasp);
    OutTextXY(502,140,'Computer:'); OutTextXY(590,140,stacsp);
    if (sp = 19) or (csp = 19) then begin
      OutTextXY(502,5,'final score:');
      if sp=19 then OutTextXY(502,69,'20')
               else OutTextXY(502,140,'20');
    end;
  end;

procedure bildaufbau(spx,spy,cspx,cspy,bax,bay:integer);
  begin
    fensteraufbau(0,0,500,250,9,10);     {Spielfeld}
    fensteraufbau(0,251,640,350,1,4);    {Textfeld}
    SetTextStyle(2,0,4);
    SetColor(15);
    SetTextJustify(1,0);
    SetTextJustify(0,1);
    zaehler;
    SetColor(15); SetLineStyle(0,0,3);
    Rectangle(2,2,498,248);                         {Grundlienien}
    Line(249,2,249,250); Circle(250,125,70);        {Mittelline,Anstokreis}
    Rectangle(2,60,82,195);Rectangle(418,60,498,195); {Strafrume}
    SetLineStyle(0,0,1);
    Rectangle(2,95,32,155); Rectangle(468,95,498,155);     {Torrume}
    SetColor(0); SetLineStyle(0,0,3);
    Line(2,105,2,145);                      {linkes Tor}
    Line(498,105,498,145);                  {rechtes Tor}
    spieler(spx,spy,1,'r');                     {Spieler}
    spieler(cspx,cspy,4,'l');                     {Computerspieler}
    ballzeichn(bax,bay);                          {Ball}
  end;

procedure bildaufbauanf;
  begin
    fensteraufbau(0,0,500,250,9,10);     {Spielfeld}
    fensteraufbau(0,251,640,350,1,4);    {Textfeld}
    zaehler;
    SetColor(15); SetLineStyle(0,0,3);
    Rectangle(2,2,498,248);                         {Grundlienien}
    Line(249,2,249,250); Circle(250,125,70);        {Mittelline,Anstokreis}
    Rectangle(2,60,82,195);Rectangle(418,60,498,195); {Strafrume}
    SetLineStyle(0,0,1);
    Rectangle(2,95,32,155); Rectangle(468,95,498,155);     {Torrume}
    SetColor(0); SetLineStyle(0,0,3);
    Line(2,105,2,145);                      {linkes Tor}
    Line(498,105,498,145);                  {rechtes Tor}
    spieler(200,80,1,'r');                     {Spieler}
    spieler(265,80,4,'l');                     {Computerspieler}
    ballzeichn(250,125);
  end;
procedure Text1;
  begin
    SetColor(15);
    SetTextJustify(1,1);
    SetTextStyle(2,0,6);
    OutTextXY(250,275,'Start!');
    end;
procedure Text2(col, line: integer; woerter: schreibtyp);
  var a,b,c,d: integer;
  begin
    SetColor(15);
    SetTextStyle(0,0,1);
    SetTextJustify(0,1);
    OutTextXY(col, line, woerter);
  end;


procedure weiter;
  var zeichen: char;
  begin
    repeat
    SetTextStyle(2,0,4);
    SetColor(15);
    SetTextJustify(1,0);
    OutTextxy(320,348,'Press   "Space" !');
    zeichen:='';
    zeichen:=readkey;
   until zeichen=' ';
  end;

procedure spiela;
  procedure wortvergl;
    var wort:string[30];
        zufall: integer;
        anzahl: integer;
        ax,ay,bx,by,cx,cy:integer;
        tor: boolean;
        vor:boolean;
        ent:integer;
        x: byte;
        l,m: integer;
        seites, seitec: integer;
        vergleich: boolean;
    function bewegent: integer;
      var fall: integer;
      begin
        randomize;
        fall:=random(3);
        if fall=0 then bewegent:=-30;
        if fall=1 then bewegent:=0;
        if fall=2 then bewegent:=30;
      end;
    begin
      sp:=0;
      csp:=0;
    repeat
      SetVisualPage(0);
      SetActivePage(0);
      ClearDevice;
      ax:=200;ay:=80;bx:=265;by:=80;cx:=250;cy:=125;
      Bildaufbau(ax,ay,bx,by,cx,cy);
      assign(substfile, oname);
      reset(substfile);
      anzahl:=filesize(substfile);
      vor:=true;
      while ((cx<>100) and (vor<>true)) or ((cx<>400) and (vor<>false))
      do begin
        randomize;
        zufall:=random(anzahl);
        seek(substfile,zufall);
        read(substfile, eintrag);
        SetVisualPage(0);
        SetActivePage(0);
        fensteraufbau(0,251,640,350,1,4);
        Text2(0,260,'Translate  into  German:');
        Text2(0,270,eintrag.wortengl);
        verglei.wortdt:='                              ';
        gotoxy(2,21); readln(verglei.wortdt);
        if (verglei.wortdt) = (eintrag.wortdt)
          then begin
            vor:=true;
            ent:=bewegent;
            ax:=ax+50;ay:=ay+ent;bx:=bx+50;by:=by+ent;cx:=cx+50;cy:=cy+ent;
            l:=50; m:=0;
            seites:=0;
            for x:= 1 to 5 do begin
             l:=l-10;
             if ent=-30 then m:=m+5;
             if ent=0   then m:=0;
             if ent=30  then m:=m-5;
             if (ay<60) then
                begin ay:=60; by:=60; cy:=105;
                end;
              if (ay>100) then
                begin ay:=130; by:=130; cy:= 175;
                end;
              SetVisualPage(seites);
              Inc(seites);
              if seites > 1 then seites:=0;
              SetActivePage(seites);
              Bildaufbau(ax-l,ay-m,bx-l,by-m,cx-l,cy-m);
            end;
          end
          else begin
            vor:=false;
            ent:=bewegent;
            ax:=ax-50;ay:=ay+ent;bx:=bx-50;by:=by+ent;cx:=cx-50;cy:=cy+ent;
            l:=50; m:=0;
            seitec:=0;
            for x:= 1 to 5 do begin
              l:=l-10;
              if ent=-30 then m:=m+5;
              if ent=0   then m:=0;
              if ent=30  then m:=m-5;
              if (ay<60) then
                begin ay:=60; by:=60; cy:=105;
                end;
              if (ay>100) then
                begin ay:=130; by:=130; cy:= 175;
                end;
              SetVisualPage(seitec);
              Inc(seitec);
              if seitec > 1 then seitec:=0;
              SetActivePage(seitec);
              Bildaufbau(ax+l,ay-m,bx+l,by-m,cx+l,cy-m);
            end;
          end;
        end;
        SetVisualPage(1);
        SetActivePage(1);
        if (cx=100) then
          begin Bildaufbau(ax-l,ay-m,bx-l,by-m,0,125);
          csp:=csp+1;
          zaehler;
        end;
        if (cx=400) then
          begin Bildaufbau(ax+l,ay-m,bx+l,by-m,500,125);
          sp:=sp+1;
          zaehler;
        end;
      OutTextXY(502,200,'exit     : Esc');
      OutTextXY(502,210,'continue : Space');
      beenden:=readkey;
      ClearDevice;
    until (sp=19) or (csp=19) or (beenden=#27);
    close(substfile);
    end;
begin
  grafstart;
  SetVisualPage(0);
  sp:=0;
  csp:=0;
  bildaufbauanf;
  Text1;
  SetActivePage(0);
  weiter;
  wortvergl;
  TextMode(3);
end;

procedure spielb;
  procedure wortvergl;
    var wort:string[30];
        zufall: integer;
        anzahl: integer;
        ax,ay,bx,by,cx,cy:integer;
        tor: boolean;
        vor:boolean;
        ent:integer;
        x: byte;
        l,m: integer;
        seites, seitec: integer;
        vergleich:boolean;
    function bewegent: integer;
      var fall: integer;
      begin
        randomize;
        fall:=random(3);
        if fall=0 then bewegent:=-30;
        if fall=1 then bewegent:=0;
        if fall=2 then bewegent:=30;
      end;

    begin
      sp:=0;
      csp:=0;
    repeat
      SetVisualPage(0);
      SetActivePage(0);
      ClearDevice;
      ax:=200;ay:=80;bx:=265;by:=80;cx:=250;cy:=125;
      Bildaufbau(ax,ay,bx,by,cx,cy);
      assign(substfile, oname);
      reset(substfile);
      anzahl:=filesize(substfile);
      vor:=true;
      while ((cx<>100) and (vor<>true)) or ((cx<>400) and (vor<>false))
      do begin
        randomize;
        zufall:=random(anzahl);
        seek(substfile,zufall);
        read(substfile, eintrag);
        SetActivePage(0);
        SetVisualPage(0);
        fensteraufbau(0,251,640,350,1,4);
        Text2(0,260,'Give the article:');
        Text2(0,270,eintrag.wortdt);
        verglei.artikel:='   ';
        gotoxy(2,21); readln(verglei.artikel);
        if (verglei.artikel) = (eintrag.artikel)
          then begin
            vor:=true;
            ent:=bewegent;
            ax:=ax+50;ay:=ay+ent;bx:=bx+50;by:=by+ent;cx:=cx+50;cy:=cy+ent;
            l:=50; m:=0;
            seites:=0;
            for x:= 1 to 5 do begin
             l:=l-10;
             if ent=-30 then m:=m+5;
             if ent=0   then m:=0;
             if ent=30  then m:=m-5;
             if (ay<60) then
                begin ay:=60; by:=60; cy:=105;
                end;
              if (ay>100) then
                begin ay:=130; by:=130; cy:= 175;
                end;
              SetVisualPage(seites);
              Inc(seites);
              if seites > 1 then seites:=0;
              SetActivePage(seites);
              Bildaufbau(ax-l,ay-m,bx-l,by-m,cx-l,cy-m);
            end;
          end
          else begin
            vor:=false;
            ent:=bewegent;
            ax:=ax-50;ay:=ay+ent;bx:=bx-50;by:=by+ent;cx:=cx-50;cy:=cy+ent;
            l:=50; m:=0;
            seitec:=0;
            for x:= 1 to 5 do begin
              l:=l-10;
              if ent=-30 then m:=m+5;
              if ent=0   then m:=0;
              if ent=30  then m:=m-5;
              if (ay<60) then
                begin ay:=60; by:=60; cy:=105;
                end;
              if (ay>100) then
                begin ay:=130; by:=130; cy:= 175;
                end;
              SetVisualPage(seitec);
              Inc(seitec);
              if seitec > 1 then seitec:=0;
              SetActivePage(seitec);
              Bildaufbau(ax+l,ay-m,bx+l,by-m,cx+l,cy-m);
            end;
          end;
        end;
        SetVisualPage(1);
        SetActivePage(1);
        if (cx=100) then
          begin Bildaufbau(ax-l,ay-m,bx-l,by-m,0,125);
          csp:=csp+1;
          zaehler;
        end;
        if (cx=400) then
          begin Bildaufbau(ax+l,ay-m,bx+l,by-m,500,125);
          sp:=sp+1;
          zaehler;
        end;
      OutTextXY(502,200,'exit     : Esc');
      OutTextXY(502,210,'continue : Space');
      beenden:=readkey;
      ClearDevice;
    until (sp=19) or (csp=19) or (beenden=#27);
    close(substfile);
    end;
begin
  grafstart;
  SetVisualPage(0);
  sp:=0;
  csp:=0;
  bildaufbauanf;
  Text1;
  SetActivePage(0);
  weiter;
  wortvergl;
  TextMode(3);
end;

procedure spielc;
  procedure wortvergl;
    var wort:string[30];
        zufall: integer;
        anzahl: integer;
        ax,ay,bx,by,cx,cy:integer;
        tor: boolean;
        vor:boolean;
        ent:integer;
        x: byte;
        l,m: integer;
        seites, seitec: integer;
        vergleich:boolean;
    function bewegent: integer;
      var fall: integer;
      begin
        randomize;
        fall:=random(3);
        if fall=0 then bewegent:=-30;
        if fall=1 then bewegent:=0;
        if fall=2 then bewegent:=30;
      end;

    begin
      sp:=0;
      csp:=0;
    repeat
      SetVisualPage(0);
      SetActivePage(0);
      ClearDevice;
      ax:=200;ay:=80;bx:=265;by:=80;cx:=250;cy:=125;
      Bildaufbau(ax,ay,bx,by,cx,cy);
      assign(substfile, oname);
      reset(substfile);
      anzahl:=filesize(substfile);
      vor:=true;
      while ((cx<>100) and (vor<>true)) or ((cx<>400) and (vor<>false))
      do begin
        randomize;
        zufall:=random(anzahl);
        seek(substfile,zufall);
        read(substfile, eintrag);
        SetActivePage(0);
        SetVisualPage(0);
        fensteraufbau(0,251,640,350,1,4);
        Text2(0,260,'Give the plural form:');
        Text2(0,270,eintrag.wortdt);
        verglei.wortdt:='                              ';
        gotoxy(2,21); readln(verglei.wortpl);
        if (verglei.wortpl) = (eintrag.wortpl)
          then begin
            vor:=true;
            ent:=bewegent;
            ax:=ax+50;ay:=ay+ent;bx:=bx+50;by:=by+ent;cx:=cx+50;cy:=cy+ent;
            l:=50; m:=0;
            seites:=0;
            for x:= 1 to 5 do begin
             l:=l-10;
             if ent=-30 then m:=m+5;
             if ent=0   then m:=0;
             if ent=30  then m:=m-5;
             if (ay<60) then
                begin ay:=60; by:=60; cy:=105;
                end;
              if (ay>100) then
                begin ay:=130; by:=130; cy:= 175;
                end;
              SetVisualPage(seites);
              Inc(seites);
              if seites > 1 then seites:=0;
              SetActivePage(seites);
              Bildaufbau(ax-l,ay-m,bx-l,by-m,cx-l,cy-m);
            end;
          end
          else begin
            vor:=false;
            ent:=bewegent;
            ax:=ax-50;ay:=ay+ent;bx:=bx-50;by:=by+ent;cx:=cx-50;cy:=cy+ent;
            l:=50; m:=0;
            seitec:=0;
            for x:= 1 to 5 do begin
              l:=l-10;
              if ent=-30 then m:=m+5;
              if ent=0   then m:=0;
              if ent=30  then m:=m-5;
              if (ay<60) then
                begin ay:=60; by:=60; cy:=105;
                end;
              if (ay>100) then
                begin ay:=130; by:=130; cy:= 175;
                end;
              SetVisualPage(seitec);
              Inc(seitec);
              if seitec > 1 then seitec:=0;
              SetActivePage(seitec);
              Bildaufbau(ax+l,ay-m,bx+l,by-m,cx+l,cy-m);
            end;
          end;
        end;
        SetVisualPage(1);
        SetActivePage(1);
        if (cx=100) then
          begin Bildaufbau(ax-l,ay-m,bx-l,by-m,0,125);
          csp:=csp+1;
          zaehler;
        end;
        if (cx=400) then
          begin Bildaufbau(ax+l,ay-m,bx+l,by-m,500,125);
          sp:=sp+1;
          zaehler;
        end;
      OutTextXY(502,200,'exit     : Esc');
      OutTextXY(502,210,'continue : Space');
      beenden:=readkey;
      ClearDevice;
    until (sp=19) or (csp=19) or (beenden=#27);
    close(substfile);
    end;
begin
  grafstart;
  SetVisualPage(0);
  sp:=0;
  csp:=0;
  bildaufbauanf;
  Text1;
  SetActivePage(0);
  weiter;
  wortvergl;
  TextMode(3);
end;

procedure spield;
  procedure wortvergl;
    var wort:string[30];
        zufall: integer;
        anzahl: integer;
        ax,ay,bx,by,cx,cy:integer;
        tor: boolean;
        vor:boolean;
        ent:integer;
        x: byte;
        l,m: integer;
        seites, seitec: integer;
        vergleich:boolean;
    function bewegent: integer;
      var fall: integer;
      begin
        randomize;
        fall:=random(3);
        if fall=0 then bewegent:=-30;
        if fall=1 then bewegent:=0;
        if fall=2 then bewegent:=30;
      end;

    begin
      sp:=0;
      csp:=0;
    repeat
      SetVisualPage(0);
      SetActivePage(0);
      ClearDevice;
      ax:=200;ay:=80;bx:=265;by:=80;cx:=250;cy:=125;
      Bildaufbau(ax,ay,bx,by,cx,cy);
      assign(substfile, oname);
      reset(substfile);
      anzahl:=filesize(substfile);
      vor:=true;
      while ((cx<>100) and (vor<>true)) or ((cx<>400) and (vor<>false))
      do begin
        randomize;
        zufall:=random(anzahl);
        seek(substfile,zufall);
        read(substfile, eintrag);
        SetActivePage(0);
        SetVisualPage(0);
        fensteraufbau(0,251,640,350,1,4);
        Text2(0,260,'Translate into German!');
        Text2(0,270,eintrag.wortengl);
        verglei.wortdt:='                              ';
        gotoxy(2,21); readln(verglei.wortdt);
        Text2(0,301,'Give the article!');
        verglei.artikel:='   ';
        gotoxy(2,23);readln(verglei.artikel);
        if ((verglei.wortdt) = (eintrag.wortdt)) and ((verglei.artikel) = (eintrag.artikel))
          then begin
            vor:=true;
            ent:=bewegent;
            ax:=ax+50;ay:=ay+ent;bx:=bx+50;by:=by+ent;cx:=cx+50;cy:=cy+ent;
            l:=50;  m:=0;
            seites:=0;
            for x:= 1 to 5 do begin
             l:=l-10;
             if ent=-30 then m:=m+5;
             if ent=0   then m:=0;
             if ent=30  then m:=m-5;
             if (ay<60) then
                begin ay:=60; by:=60; cy:=105;
                end;
              if (ay>100) then
                begin ay:=130; by:=130; cy:= 175;
                end;
              SetVisualPage(seites);
              Inc(seites);
              if seites > 1 then seites:=0;
              SetActivePage(seites);
              Bildaufbau(ax-l,ay-m,bx-l,by-m,cx-l,cy-m);
            end;
          end
          else begin
            vor:=false;
            ent:=bewegent;
            ax:=ax-50;ay:=ay+ent;bx:=bx-50;by:=by+ent;cx:=cx-50;cy:=cy+ent;
            l:=50;  m:=0;
            seitec:=0;
            for x:= 1 to 5 do begin
              l:=l-10;
              if ent=-30 then m:=m+5;
              if ent=0   then m:=0;
              if ent=30  then m:=m-5;
              if (ay<60) then
                begin ay:=60; by:=60; cy:=105;
                end;
              if (ay>100) then
                begin ay:=130; by:=130; cy:= 175;
                end;
              SetVisualPage(seitec);
              Inc(seitec);
              if seitec > 1 then seitec:=0;
              SetActivePage(seitec);
              Bildaufbau(ax+l,ay-m,bx+l,by-m,cx+l,cy-m);
            end;
          end;
        end;
        SetVisualPage(1);
        SetActivePage(1);
        if (cx=100) then
          begin Bildaufbau(ax-l,ay-m,bx-l,by-m,0,125);
          csp:=csp+1;
          zaehler;
        end;
        if (cx=400) then
          begin Bildaufbau(ax+l,ay-m,bx+l,by-m,500,125);
          sp:=sp+1;
          zaehler;
        end;
      OutTextXY(502,200,'exit     : Esc');
      OutTextXY(502,210,'continue : Space');
      beenden:=readkey;
      ClearDevice;
    until (sp=19) or (csp=19) or (beenden=#27);
    close(substfile);
    end;
begin
  grafstart;
  SetVisualPage(0);
  sp:=0;
  csp:=0;
  bildaufbauanf;
  Text1;
  SetActivePage(0);
  weiter;
  wortvergl;
  TextMode(3);
end;

procedure spiele;
  procedure wortvergl;
    var wort:string[30];
        zufall: integer;
        anzahl: integer;
        ax,ay,bx,by,cx,cy:integer;
        tor: boolean;
        vor:boolean;
        ent:integer;
        x: byte;
        l,m: integer;
        seites, seitec: integer;
        vergleich:boolean;
    function bewegent: integer;
      var fall: integer;
      begin
        randomize;
        fall:=random(3);
        if fall=0 then bewegent:=-30;
        if fall=1 then bewegent:=0;
        if fall=2 then bewegent:=30;
      end;

    begin
      sp:=0;
      csp:=0;
    repeat
      SetVisualPage(0);
      SetActivePage(0);
      ClearDevice;
      ax:=200;ay:=80;bx:=265;by:=80;cx:=250;cy:=125;
      Bildaufbau(ax,ay,bx,by,cx,cy);
      assign(substfile, oname);
      reset(substfile);
      anzahl:=filesize(substfile);
      vor:=true;
      while ((cx<>100) and (vor<>true)) or ((cx<>400) and (vor<>false))
      do begin
        randomize;
        zufall:=random(anzahl);
        seek(substfile,zufall);
        read(substfile, eintrag);
        SetActivePage(0);
        SetVisualPage(0);
        fensteraufbau(0,251,640,350,1,4);
        Text2(0,260,'Translate into German!');
        Text2(0,270,eintrag.wortengl);
        verglei.wortdt:='                              ';
        gotoxy(2,21); readln(verglei.wortdt);
        Text2(0,301,'Give the plural form!');
        gotoxy(2,23); readln(verglei.wortpl);
        if ((verglei.wortdt) = (eintrag.wortdt)) and ((verglei.wortpl) = (eintrag.wortpl))
          then begin
            vor:=true;
            ent:=bewegent;
            ax:=ax+50;ay:=ay+ent;bx:=bx+50;by:=by+ent;cx:=cx+50;cy:=cy+ent;
            l:=50;  m:=0;
            seites:=0;
            for x:= 1 to 5 do begin
             l:=l-10;
             if ent=-30 then m:=m+5;
             if ent=0   then m:=0;
             if ent=30  then m:=m-5;
             if (ay<60) then
                begin ay:=60; by:=60; cy:=105;
                end;
              if (ay>100) then
                begin ay:=130; by:=130; cy:= 175;
                end;
              SetVisualPage(seites);
              Inc(seites);
              if seites > 1 then seites:=0;
              SetActivePage(seites);
              Bildaufbau(ax-l,ay-m,bx-l,by-m,cx-l,cy-m);
            end;
          end
          else begin
            vor:=false;
            ent:=bewegent;
            ax:=ax-50;ay:=ay+ent;bx:=bx-50;by:=by+ent;cx:=cx-50;cy:=cy+ent;
            l:=50;  m:=0;
            seitec:=0;
            for x:= 1 to 5 do begin
              l:=l-10;
              if ent=-30 then m:=m+5;
              if ent=0   then m:=0;
              if ent=30  then m:=m-5;
              if (ay<60) then
                begin ay:=60; by:=60; cy:=105;
                end;
              if (ay>100) then
                begin ay:=130; by:=130; cy:= 175;
                end;
              SetVisualPage(seitec);
              Inc(seitec);
              if seitec > 1 then seitec:=0;
              SetActivePage(seitec);
              Bildaufbau(ax+l,ay-m,bx+l,by-m,cx+l,cy-m);
            end;
          end;
        end;
        SetVisualPage(1);
        SetActivePage(1);
        if (cx=100) then
          begin Bildaufbau(ax-l,ay-m,bx-l,by-m,0,125);
          csp:=csp+1;
          zaehler;
        end;
        if (cx=400) then
          begin Bildaufbau(ax+l,ay-m,bx+l,by-m,500,125);
          sp:=sp+1;
          zaehler;
        end;
      OutTextXY(502,200,'exit     : Esc');
      OutTextXY(502,210,'continue : Space');
      beenden:=readkey;
      ClearDevice;
    until (sp=19) or (csp=19) or (beenden=#27);
    close(substfile);
    end;
begin
  grafstart;
  SetVisualPage(0);
  sp:=0;
  csp:=0;
  bildaufbauanf;
  Text1;
  SetActivePage(0);
  weiter;
  wortvergl;
  TextMode(3);
end;

procedure spielf;
  procedure wortvergl;
    var wort:string[30];
        zufall: integer;
        anzahl: integer;
        ax,ay,bx,by,cx,cy:integer;
        tor: boolean;
        vor:boolean;
        ent:integer;
        x: byte;
        l,m: integer;
        seites, seitec: integer;
        vergleich:boolean;
    function bewegent: integer;
      var fall: integer;
      begin
        randomize;
        fall:=random(3);
        if fall=0 then bewegent:=-30;
        if fall=1 then bewegent:=0;
        if fall=2 then bewegent:=30;
      end;

    begin
      sp:=0;
      csp:=0;
    repeat
      SetVisualPage(0);
      SetActivePage(0);
      ClearDevice;
      ax:=200;ay:=80;bx:=265;by:=80;cx:=250;cy:=125;
      Bildaufbau(ax,ay,bx,by,cx,cy);
      assign(substfile, oname);
      reset(substfile);
      anzahl:=filesize(substfile);
      vor:=true;
      while ((cx<>100) and (vor<>true)) or ((cx<>400) and (vor<>false))
      do begin
        randomize;
        zufall:=random(anzahl);
        seek(substfile,zufall);
        read(substfile, eintrag);
        SetActivePage(0);
        SetVisualPage(0);
        fensteraufbau(0,251,640,350,1,4);
        Text2(0,260,'Translate into German!');
        Text2(0,270,eintrag.wortengl);
        verglei.wortdt:='                              ';
        gotoxy(2,21); readln(verglei.wortdt);
        Text2(0,260,'                                         Give the article!');
        gotoxy(45,21); readln(verglei.artikel);
        Text2(0,301,'Give the plural form!');
        gotoxy(2,23); readln(verglei.wortpl);
   if ((verglei.wortdt)=(eintrag.wortdt)) and ((verglei.wortpl)=(eintrag.wortpl)) and ((verglei.artikel)=(eintrag.artikel))
          then begin
            vor:=true;
            ent:=bewegent;
            ax:=ax+50;ay:=ay+ent;bx:=bx+50;by:=by+ent;cx:=cx+50;cy:=cy+ent;
            l:=50;  m:=0;
            seites:=0;
            for x:= 1 to 5 do begin
             l:=l-10;
             if ent=-30 then m:=m+5;
             if ent=0   then m:=0;
             if ent=30  then m:=m-5;
             if (ay<60) then
                begin ay:=60; by:=60; cy:=105;
                end;
              if (ay>100) then
                begin ay:=130; by:=130; cy:= 175;
                end;
              SetVisualPage(seites);
              Inc(seites);
              if seites > 1 then seites:=0;
              SetActivePage(seites);
              Bildaufbau(ax-l,ay-m,bx-l,by-m,cx-l,cy-m);
            end;
          end
          else begin
            vor:=false;
            ent:=bewegent;
            ax:=ax-50;ay:=ay+ent;bx:=bx-50;by:=by+ent;cx:=cx-50;cy:=cy+ent;
            l:=50;  m:=0;
            seitec:=0;
            for x:= 1 to 5 do begin
              l:=l-10;
              if ent=-30 then m:=m+5;
              if ent=0   then m:=0;
              if ent=30  then m:=m-5;
              if (ay<60) then
                begin ay:=60; by:=60; cy:=105;
                end;
              if (ay>100) then
                begin ay:=130; by:=130; cy:= 175;
                end;
              SetVisualPage(seitec);
              Inc(seitec);
              if seitec > 1 then seitec:=0;
              SetActivePage(seitec);
              Bildaufbau(ax+l,ay-m,bx+l,by-m,cx+l,cy-m);
            end;
          end;
        end;
        SetVisualPage(1);
        SetActivePage(1);
        if (cx=100) then
          begin Bildaufbau(ax-l,ay-m,bx-l,by-m,0,125);
          csp:=csp+1;
          zaehler;
        end;
        if (cx=400) then
          begin Bildaufbau(ax+l,ay-m,bx+l,by-m,500,125);
          sp:=sp+1;
          zaehler;
        end;
      OutTextXY(502,200,'exit     : Esc');
      OutTextXY(502,210,'continue : Space');
      beenden:=readkey;
      ClearDevice;
    until (sp=19) or (csp=19) or (beenden=#27);
    close(substfile);
    end;
begin
  grafstart;
  SetVisualPage(0);
  sp:=0;
  csp:=0;
  bildaufbauanf;
  Text1;
  SetActivePage(0);
  weiter;
  wortvergl;
  TextMode(3);
end;

{Beginn von writeln an Zeile, Spalte}
procedure schreibxy(spalte, zeile: byte; schreib: schreibtyp);
  begin
    gotoXY(spalte, zeile);
    writeln(schreib);
    end;

{Text- und Hintergrundfarbe im CRT-Modus festlegen}
procedure crtfarbe(a, b:byte);
  begin
    TextColor(a);
    TextBackGround(b);
    end;
{Aufruf einer Bildmaske im Fenster mit flgd. Begrenzung}
procedure mskruf(maske: msktyp; a,b,c,d,e,f: byte);
  var bmaske: text;
      zeile: string[80];
  begin
    assign(bmaske, maske);
    reset(bmaske);
    crtfarbe(e,f);
    window(a,b,c,d); Clrscr;
    while not eof(bmaske) do
      begin readln(bmaske, zeile);
            writeln(zeile);
      end;
    zeichen:=readkey;
    crtfarbe(x,y); ClrScr; window(1,1,80,25);
    close(bmaske);
   end;

{Aufruf einer Fehlermeldung im Fenster mit flgd. Begrenzung}
procedure fehmeld(maske: msktyp; a,b,c,d,e,f: byte);
  var bmaske: text;
      zeile: string[80];
  begin
    assign(bmaske, maske);
    reset(bmaske);
    crtfarbe(e,f);
    window(a,b,c,d); Clrscr;
    while not eof(bmaske) do
      begin readln(bmaske, zeile);
            writeln(zeile);
      end;
    delay(5000);
    crtfarbe(x,y); ClrScr; window(1,1,80,25);
    close(bmaske);
   end;

{Aufruf einer Meldung im Fenster mit flgd. Begrenzung}
procedure meld(maske: msktyp; a,b,c,d,e,f: byte);
  var bmaske: text;
      zeile: string[80];
  begin
    assign(bmaske, maske);
    reset(bmaske);
    crtfarbe(e,f);
    window(a,b,c,d); Clrscr;
    while not eof(bmaske) do
      begin readln(bmaske, zeile);
            writeln(zeile);
      end;
    close(bmaske);
   end;

procedure inhaltpruefen;
  begin
        {$I-}
        read(substfile, eintrag);
        fehler:=IORESULT;
        if fehler <> 0
          then begin
            sound(1000); delay(500); nosound;
            schreibxy(1,15,'File has no data');
            delay(2000); gotoxy(1,15); ClrEol;
            repeat
              schreibxy(1,15,'Press x and add data,');
              schreibxy(1,17,'  or choose new file!');
              zeichen := readkey;
            until (zeichen in ['x','X']) or (fehler = 0);
          end;
        {$I+}
  end;

{ffnen einer Datei: Typ:substfiletyp}
procedure dateioeffnen(var dateiname: substfiletyp);
  label wieder;
  begin
  {$I-}
    reset(dateiname);
    fehler:=IOresult;
    if fehler <> 0
      then begin
        sound(1000); delay(300); nosound;
        fehmeld('a:\fehler6.msk',1,22,80,24,15,4);
        delay(4000); goto wieder;
        end;
  {$I+}
  wieder:{$I+};
  end;

{ffnen der Datei mit Namen}
procedure oeffnen;
  var Error: integer;
      z: byte;
  begin
    repeat
    ClrScr; crtfarbe(15,1); ClrScr;
    schreibxy(1,1,'Choose path and file!');
    schreibxy(1,2,'First give the path(e.g. a:\):');
    gotoxy(42,2); readln(spfad);
    suchpfad := spfad + sname;
    Error:= 0;
    FindFirst(suchpfad, AnyFile, datei);
    Error:= DOSError;
    z := 4;
    while Error = 0 do begin
      schreibxy(1,z,datei.name);
      FindNext (datei);
      Error := DOSError;
      z:= z + 1;
    end;
      if Error = 18
        then begin
            crtfarbe(15,1);
            schreibxy(1,(z+1),'Which file do you want?:');
            schreibxy(1,(z+2),'file name(8 characters) only, not ".dat"');
            gotoxy(28,(z+1)); ClrEol; readln(name);
            oname := spfad + name + erwei;
            assign(substfile, oname);
            dateioeffnen(substfile);
        end
        else begin
          gotoxy(1,z); writeln('Exit! DOS-ERROR: ', Error);
          writeln('Check path, spelling! File existant?');
          delay(2000);
          end;
    until (fehler=0) and (error=18);
  end;


{Datensatz  suchen}
  procedure suchen;
    var suchwort:string[30];
    var vergleichswort:string[30];
    var zeichen:char;
    var wort:string[30];
    procedure dtenglsuchen;
      label away;
      begin
        seek(substfile, 0);
        ClrScr; schreibxy(1,1,'Which word ?  :');
        gotoxy(1,2);readln(vergleichswort); ClrScr;
        writeln('pleas wait - searching!');
        repeat
        {$I-}
        read(substfile, eintrag);
        if IORESULT <> 0
          then begin
            sound(1000); delay(500); nosound;
            schreibxy(1,15,'No data in this file');
            delay(2000); gotoxy(1,15); ClrEol;
            repeat
              schreibxy(1,15,'Press x and add data,');
              schreibxy(1,17,'or choose new file!');
              zeichen := readkey;
              if zeichen = 'x'
                then goto away;
            until zeichen = 'x';
          end;
        {$I+}
        suchwort:= '                              ';
        repeat
          case zeichen of
            'd': suchwort:= eintrag.wortdt;
            'D': suchwort:= eintrag.wortdt;
            'e': suchwort:= eintrag.wortengl;
            'E': suchwort:= eintrag.wortengl;
          end;
        until zeichen in ['d','D','e','E','x','X'];
      until (suchwort=vergleichswort) or (eof(substfile));
      ClrScr;
      window(1,1,80,25);
        if suchwort=vergleichswort
          then begin
            seek(substfile, eintrag.satznr - 0);
            gotoxy(14,12); ClrEol; writeln(eintrag.artikel);
            gotoxy(14,14); ClrEol; writeln(eintrag.wortdt);
            gotoxy(14,16); ClrEol; writeln(eintrag.wortpl);
            gotoxy(14,18); ClrEol; writeln(eintrag.wortengl);
            end
          else begin
            schreibxy(14,8,'Word not found!');
            delay(1000); gotoxy(14,8); ClrEol;
            end;
        away: {$I+};
      end;
    begin
      repeat
      vergleichswort:='                               ';
      window(50,10,80,13);
      schreibxy(1,1,'    search German word - d');
      schreibxy(1,2,'   search English word - e');
      schreibxy(1,3,'                  exit - x');
        zeichen:=readkey;
        case zeichen of
          'd':dtenglsuchen;
          'e':dtenglsuchen;
          'x':ClrScr;
          end;
      until zeichen='x';
      window(1,1,80,25);
    end;

{Datei lesen}
  procedure lesen;
    label weg;
    begin
      ClrScr; crtfarbe(15,1); ClrScr; crtfarbe(15,0);
      schreibxy(56,1,'forward     - any key ');
      schreibxy(56,2,'back        - z       ');
      schreibxy(56,3,'search      - s       ');
      schreibxy(56,4,'finish      - x       ');
      crtfarbe(15,1);
      schreibxy(1,12,'article   :');
      schreibxy(1,14,'Germ.word :');
      schreibxy(1,16,'plural    :');
      schreibxy(1,18,'Engl.word :');
      seek(substfile, 0);
      repeat
        {$I-}
        read(substfile, eintrag);
        if IORESULT <> 0
          then begin
            repeat
              sound(1000); delay(500); nosound;
              mskruf('a:\fenst4.msk',25,12,57,18,15,4);
              if zeichen = 'x'
                then goto weg;
            until zeichen = 'x';
          end;
        {$I+}
        gotoxy(14,12); ClrEol; writeln(eintrag.artikel);
        gotoxy(14,14); ClrEol; writeln(eintrag.wortdt);
        gotoxy(14,16); ClrEol; writeln(eintrag.wortpl);
        gotoxy(14,18); ClrEol; writeln(eintrag.wortengl);
        zeichen := readkey;
        case zeichen of
          'x': ClrScr;
          's': suchen;
          'w': seek(substfile, (eintrag.satznr + 1));
          'z': seek(substfile, (eintrag.satznr - 1));
        end;
        until (zeichen='x') or (eof(substfile)) or (eintrag.satznr = -1);
        weg: {$I+};
    end;

{bei msk-Aufrufen, Programmaufrufen spter a:\ entfernen}
begin
  repeat
  repeat
    ClrScr; crtfarbe(15,1); ClrScr;
    oeffnen;
    inhaltpruefen;
  until (zeichen='x') or (fehler=0);
  crtfarbe(15,1); ClrScr;
  crtfarbe(15,0); window(15,10,61,13); ClrScr;
  schreibxy(2,2,'Do you want to have a look at the words,');
  schreibxy(2,3,'their article and their plural form? (j/n)?');
  zeichen:=readkey;
  window(1,1,80,25);
  if zeichen in ['j','J']
    then lesen;
  repeat
    crtfarbe(15,1); ClrScr;
    mskruf('a:\fenst5.msk',15,7,63,20,15,0);
    crtfarbe(15,0); ClrScr;
    case zeichen of
      'a':spiela;
      'b':spielb;
      'c':spielc;
      'd':spield;
      'e':spiele;
      'f':spielf;
    end;
    until zeichen in ['y','x'];
  until zeichen = 'x';
end.

